/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tfar.metalbarrels.container.MetalBarrelContainer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MetalBarrelScreen
extends AbstractContainerScreen<MetalBarrelContainer> {
    private final ResourceLocation texture;
    private final boolean isTall;
    private final boolean isWide;
    private static final ResourceLocation COPPER = new ResourceLocation("metalbarrels", "textures/gui/container/copper.png");
    private static final ResourceLocation IRON = new ResourceLocation("metalbarrels", "textures/gui/container/iron.png");
    private static final ResourceLocation SILVER = new ResourceLocation("metalbarrels", "textures/gui/container/silver.png");
    private static final ResourceLocation GOLD = new ResourceLocation("metalbarrels", "textures/gui/container/gold.png");
    private static final ResourceLocation DIAMOND = new ResourceLocation("metalbarrels", "textures/gui/container/diamond.png");
    private static final ResourceLocation NETHERITE = new ResourceLocation("metalbarrels", "textures/gui/container/netherite.png");

    public MetalBarrelScreen(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component, ResourceLocation texture) {
        super((AbstractContainerMenu)barrelContainer, playerInventory, component);
        this.f_97726_ = 14 + 18 * Math.max(barrelContainer.width, 9);
        this.f_97727_ = 114 + 18 * barrelContainer.height;
        this.texture = texture;
        this.f_97731_ = this.f_97727_ - 94;
        this.isTall = this.f_97727_ > 256;
        this.isWide = this.f_97726_ > 256;
    }

    public void m_6305_(PoseStack stack, int x, int y, float p_render_3_) {
        this.m_7333_(stack);
        super.m_6305_(stack, x, y, p_render_3_);
        this.m_7025_(stack, x, y);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (!this.isTall) {
            this.m_93228_(stack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        } else if (!this.isWide) {
            MetalBarrelScreen.m_93143_((PoseStack)stack, (int)i, (int)j, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)256, (int)512);
        } else {
            MetalBarrelScreen.m_93143_((PoseStack)stack, (int)i, (int)j, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)512);
        }
    }

    public static MetalBarrelScreen copper(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, COPPER);
    }

    public static MetalBarrelScreen iron(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, IRON);
    }

    public static MetalBarrelScreen silver(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, SILVER);
    }

    public static MetalBarrelScreen gold(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, GOLD);
    }

    public static MetalBarrelScreen diamond(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, DIAMOND);
    }

    public static MetalBarrelScreen netherite(MetalBarrelContainer barrelContainer, Inventory playerInventory, Component component) {
        return new MetalBarrelScreen(barrelContainer, playerInventory, component, NETHERITE);
    }
}

